# time-stamp [![NPM version](https://img.shields.io/npm/v/time-stamp.svg?style=flat)](https://www.npmjs.com/package/time-stamp) [![NPM downloads](https://img.shields.io/npm/dm/time-stamp.svg?style=flat)](https://npmjs.org/package/time-stamp) [![Build Status](https://img.shields.io/travis/jonschlinkert/time-stamp.svg?style=flat)](https://travis-ci.org/jonschlinkert/time-stamp)

> Get a formatted timestamp.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install time-stamp --save
```

## Usage

```js
var timestamp = require('time-stamp');

timestamp();
//=> '2015:04:01'

timestamp('YYYY:MM:DD');
//=> '2015:04:01'

timestamp('[YYYY:MM:DD]');
//=> '[2015:04:01]'

timestamp('YYYY/MM/DD');
//=> '2015/04/01'

timestamp('YYYY:MM');
//=> '2015:04'

timestamp('YYYY');
//=> '2015'

timestamp('MM');
//=> '04'

timestamp('DD');
//=> '01'

timestamp('HH');
//=> '01'

timestamp('mm');
//=> '59'

timestamp('ss');
//=> '09'

timestamp('ms');
//=> '783'
```

**Valid patterns**

* `YYYY`: full year (ex: **2015**)
* `MM`: month (ex: **04**)
* `DD`: day (ex: **01**)
* `HH`: hours (ex: **12**)
* `mm`: minutes (ex: **59**)
* `ss`: seconds (ex: **09**)
* `ms`: milliseconds (ex: **532**)

## Related projects

You might also be interested in these projects:

* [days](https://www.npmjs.com/package/days): Days of the week. | [homepage](https://github.com/jonschlinkert/days)
* [iso-week](https://www.npmjs.com/package/iso-week): Get the ISO week of the year. | [homepage](https://github.com/jonschlinkert/iso-week)
* [month](https://www.npmjs.com/package/month): Get the name or number of the current month or any month of the year. | [homepage](https://github.com/datetime/month)
* [months](https://www.npmjs.com/package/months): Months of the year. | [homepage](https://github.com/jonschlinkert/months)
* [o-clock](https://www.npmjs.com/package/o-clock): Simple utility for displaying the time in 12-hour clock format. | [homepage](https://github.com/jonschlinkert/o-clock)
* [seconds](https://www.npmjs.com/package/seconds): Get the number of seconds for a minute, hour, day and week. | [homepage](https://github.com/jonschlinkert/seconds)
* [week](https://www.npmjs.com/package/week): Get the current week number. | [homepage](https://github.com/jonschlinkert/week)
* [weekday](https://www.npmjs.com/package/weekday): Get the name and number of the current weekday. Or get the name of the… [more](https://www.npmjs.com/package/weekday) | [homepage](https://github.com/jonschlinkert/weekday)
* [year](https://www.npmjs.com/package/year): Simple utility to get the current year with 2 or 4 digits. | [homepage](https://github.com/jonschlinkert/year)

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/time-stamp/issues/new).

## Building docs

Generate readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install verb && npm run docs
```

Or, if [verb](https://github.com/verbose/verb) is installed globally:

```sh
$ verb
```

## Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

## Author

**Jon Schlinkert**

Follow me on GitHub or Twitter for updates about time-stamp and my other libraries:

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/time-stamp/blob/master/LICENSE).

***

_This file was generated by [verb](https://github.com/verbose/verb), v, on April 07, 2016._